/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentIntrospectionTestBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentPropertyBeanIntrospectorTestCase
extends TestCase {
    private static Map<String, PropertyDescriptor> createDescriptorMap(PropertyDescriptor[] descs) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : descs) {
            map.put(pd.getName(), pd);
        }
        return map;
    }

    private static PropertyDescriptor fetchDescriptor(Map<String, PropertyDescriptor> props, String name) {
        FluentPropertyBeanIntrospectorTestCase.assertTrue((String)("Property not found: " + name), (boolean)props.containsKey(name));
        return props.get(name);
    }

    public void testInitNoPrefix() {
        try {
            new FluentPropertyBeanIntrospector(null);
            FluentPropertyBeanIntrospectorTestCase.fail((String)"Missing prefix for write methods not detected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntrospection() throws IntrospectionException {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        FluentPropertyBeanIntrospector introspector = new FluentPropertyBeanIntrospector();
        pu.addBeanIntrospector((BeanIntrospector)introspector);
        Map<String, PropertyDescriptor> props = FluentPropertyBeanIntrospectorTestCase.createDescriptorMap(pu.getPropertyDescriptors(FluentIntrospectionTestBean.class));
        PropertyDescriptor pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "name");
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No read method for name", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for name", (Object)pd.getWriteMethod());
        FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "stringProperty");
        pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "fluentProperty");
        FluentPropertyBeanIntrospectorTestCase.assertNull((String)"Read method for fluentProperty", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for fluentProperty", (Object)pd.getWriteMethod());
        pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "fluentGetProperty");
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No read method for fluentGetProperty", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for fluentGetProperty", (Object)pd.getWriteMethod());
    }
}

