/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanPredicate;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.NullPredicate;

public class BeanPredicateTestCase
extends TestCase {
    public BeanPredicateTestCase(String name) {
        super(name);
    }

    public void testEqual() {
        BeanPredicate predicate = new BeanPredicate("stringProperty", (Predicate)new EqualPredicate((Object)"foo"));
        BeanPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean("foo")));
        BeanPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean("bar")) ? 1 : 0) != 0);
    }

    public void testNotEqual() {
        BeanPredicate predicate = new BeanPredicate("stringProperty", (Predicate)new NotPredicate((Predicate)new EqualPredicate((Object)"foo")));
        BeanPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean("foo")) ? 1 : 0) != 0);
        BeanPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean("bar")));
    }

    public void testInstanceOf() {
        BeanPredicate predicate = new BeanPredicate("stringProperty", (Predicate)new InstanceofPredicate(String.class));
        BeanPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean("foo")));
        BeanPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean("bar")));
    }

    public void testNull() {
        BeanPredicate predicate = new BeanPredicate("stringProperty", NullPredicate.INSTANCE);
        String nullString = null;
        BeanPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean(nullString)));
        BeanPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean("bar")) ? 1 : 0) != 0);
    }
}

