/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDynaBeanTestCase
extends TestCase {
    protected DynaBean bean = null;
    protected static final String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mappedProperty", "mappedIntProperty", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};

    public BasicDynaBeanTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        DynaClass dynaClass = this.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)new Boolean(true));
        this.bean.set("booleanSecond", (Object)new Boolean(true));
        this.bean.set("doubleProperty", (Object)new Double(321.0));
        this.bean.set("floatProperty", (Object)new Float(123.0f));
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)new Integer(123));
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)new Long(321L));
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", new Integer(1));
        mappedIntProperty.put("Two", new Integer(2));
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.bean.set("shortProperty", (Object)new Short(987));
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    public static Test suite() {
        return new TestSuite(BasicDynaBeanTestCase.class);
    }

    public void tearDown() {
        this.bean = null;
    }

    public void testGetDescriptorArguments() {
        try {
            DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty("unknown");
            BasicDynaBeanTestCase.assertNull((String)"Unknown property descriptor should be null", (Object)descriptor);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of returning null"));
        }
        try {
            this.bean.getDynaClass().getDynaProperty(null);
            BasicDynaBeanTestCase.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException"));
        }
    }

    public void testGetDescriptorBoolean() {
        this.testGetDescriptorBase("booleanProperty", Boolean.TYPE);
    }

    public void testGetDescriptorDouble() {
        this.testGetDescriptorBase("doubleProperty", Double.TYPE);
    }

    public void testGetDescriptorFloat() {
        this.testGetDescriptorBase("floatProperty", Float.TYPE);
    }

    public void testGetDescriptorInt() {
        this.testGetDescriptorBase("intProperty", Integer.TYPE);
    }

    public void testGetDescriptorLong() {
        this.testGetDescriptorBase("longProperty", Long.TYPE);
    }

    public void testGetDescriptorSecond() {
        this.testGetDescriptorBase("booleanSecond", Boolean.TYPE);
    }

    public void testGetDescriptorShort() {
        this.testGetDescriptorBase("shortProperty", Short.TYPE);
    }

    public void testGetDescriptorString() {
        this.testGetDescriptorBase("stringProperty", String.class);
    }

    public void testGetDescriptors() {
        DynaProperty[] pd = this.bean.getDynaClass().getDynaProperties();
        BasicDynaBeanTestCase.assertNotNull((String)"Got descriptors", (Object)pd);
        int[] count = new int[properties.length];
        for (int i = 0; i < pd.length; ++i) {
            String name = pd[i].getName();
            for (int j = 0; j < properties.length; ++j) {
                if (!name.equals(properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < properties.length; ++j) {
            if (count[j] < 0) {
                BasicDynaBeanTestCase.fail((String)("Missing property " + properties[j]));
                continue;
            }
            if (count[j] <= 1) continue;
            BasicDynaBeanTestCase.fail((String)("Duplicate property " + properties[j]));
        }
    }

    public void testGetIndexedArguments() {
        try {
            this.bean.get("intArray", -1);
            BasicDynaBeanTestCase.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
    }

    public void testGetIndexedValues() {
        Object value = null;
        for (int i = 0; i < 5; ++i) {
            try {
                value = this.bean.get("intArray", i);
                BasicDynaBeanTestCase.assertNotNull((String)("intArray returned value " + i), (Object)value);
                BasicDynaBeanTestCase.assertTrue((String)("intArray returned Integer " + i), (boolean)(value instanceof Integer));
                BasicDynaBeanTestCase.assertEquals((String)("intArray returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                BasicDynaBeanTestCase.fail((String)("intArray " + i + " threw " + t));
            }
            try {
                value = this.bean.get("intIndexed", i);
                BasicDynaBeanTestCase.assertNotNull((String)("intIndexed returned value " + i), (Object)value);
                BasicDynaBeanTestCase.assertTrue((String)("intIndexed returned Integer " + i), (boolean)(value instanceof Integer));
                BasicDynaBeanTestCase.assertEquals((String)("intIndexed returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                BasicDynaBeanTestCase.fail((String)("intIndexed " + i + " threw " + t));
            }
            try {
                value = this.bean.get("listIndexed", i);
                BasicDynaBeanTestCase.assertNotNull((String)("listIndexed returned value " + i), (Object)value);
                BasicDynaBeanTestCase.assertTrue((String)("list returned String " + i), (boolean)(value instanceof String));
                BasicDynaBeanTestCase.assertEquals((String)("listIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                BasicDynaBeanTestCase.fail((String)("listIndexed " + i + " threw " + t));
            }
            try {
                value = this.bean.get("stringArray", i);
                BasicDynaBeanTestCase.assertNotNull((String)("stringArray returned value " + i), (Object)value);
                BasicDynaBeanTestCase.assertTrue((String)("stringArray returned String " + i), (boolean)(value instanceof String));
                BasicDynaBeanTestCase.assertEquals((String)("stringArray returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                BasicDynaBeanTestCase.fail((String)("stringArray " + i + " threw " + t));
            }
            try {
                value = this.bean.get("stringIndexed", i);
                BasicDynaBeanTestCase.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
                BasicDynaBeanTestCase.assertTrue((String)("stringIndexed returned String " + i), (boolean)(value instanceof String));
                BasicDynaBeanTestCase.assertEquals((String)("stringIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
                continue;
            }
            catch (Throwable t) {
                BasicDynaBeanTestCase.fail((String)("stringIndexed " + i + " threw " + t));
            }
        }
    }

    public void testGetMappedArguments() {
        try {
            Object value = this.bean.get("mappedProperty", "unknown");
            BasicDynaBeanTestCase.assertNull((String)"Should not return a value", (Object)value);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of returning null"));
        }
    }

    public void testGetMappedValues() {
        Object value = null;
        try {
            value = this.bean.get("mappedProperty", "First Key");
            BasicDynaBeanTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = this.bean.get("mappedProperty", "Second Key");
            BasicDynaBeanTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = this.bean.get("mappedProperty", "Third Key");
            BasicDynaBeanTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Finding third value threw " + t));
        }
    }

    public void testGetSimpleArguments() {
        try {
            this.bean.get(null);
            BasicDynaBeanTestCase.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException"));
        }
    }

    public void testGetSimpleBoolean() {
        try {
            Object value = this.bean.get("booleanProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Boolean));
            BasicDynaBeanTestCase.assertTrue((String)"Got correct value", ((Boolean)value == true ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testGetSimpleDouble() {
        try {
            Object value = this.bean.get("doubleProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Double));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (double)((Double)value), (double)321.0, (double)0.005);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetSimpleFloat() {
        try {
            Object value = this.bean.get("floatProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Float));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)123.0f, (float)0.005f);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetSimpleInt() {
        try {
            Object value = this.bean.get("intProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Integer));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (int)((Integer)value), (int)123);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetSimpleLong() {
        try {
            Object value = this.bean.get("longProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Long));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (long)((Long)value), (long)321L);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetSimpleShort() {
        try {
            Object value = this.bean.get("shortProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Short));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (short)((Short)value), (short)987);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetSimpleString() {
        try {
            Object value = this.bean.get("stringProperty");
            BasicDynaBeanTestCase.assertNotNull((String)"Got a value", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            BasicDynaBeanTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)"This is a string");
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testMappedContains() {
        try {
            BasicDynaBeanTestCase.assertTrue((String)"Can see first key", (boolean)this.bean.contains("mappedProperty", "First Key"));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
        try {
            BasicDynaBeanTestCase.assertTrue((String)"Can not see unknown key", (!this.bean.contains("mappedProperty", "Unknown Key") ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testMappedRemove() {
        try {
            BasicDynaBeanTestCase.assertTrue((String)"Can see first key", (boolean)this.bean.contains("mappedProperty", "First Key"));
            this.bean.remove("mappedProperty", "First Key");
            BasicDynaBeanTestCase.assertTrue((String)"Can not see first key", (!this.bean.contains("mappedProperty", "First Key") ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
        try {
            BasicDynaBeanTestCase.assertTrue((String)"Can not see unknown key", (!this.bean.contains("mappedProperty", "Unknown Key") ? 1 : 0) != 0);
            this.bean.remove("mappedProperty", "Unknown Key");
            BasicDynaBeanTestCase.assertTrue((String)"Can not see unknown key", (!this.bean.contains("mappedProperty", "Unknown Key") ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.bean);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            BasicDynaBeanTestCase.fail((String)("Exception during serialization: " + e));
        }
        try {
            this.bean = null;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.bean = (DynaBean)ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            BasicDynaBeanTestCase.fail((String)("Exception during deserialization: " + e));
        }
        this.testGetDescriptorArguments();
        this.testGetDescriptorBoolean();
        this.testGetDescriptorDouble();
        this.testGetDescriptorFloat();
        this.testGetDescriptorInt();
        this.testGetDescriptorLong();
        this.testGetDescriptorSecond();
        this.testGetDescriptorShort();
        this.testGetDescriptorString();
        this.testGetDescriptors();
        this.testGetIndexedArguments();
        this.testGetIndexedValues();
        this.testGetMappedArguments();
        this.testGetMappedValues();
        this.testGetSimpleArguments();
        this.testGetSimpleBoolean();
        this.testGetSimpleDouble();
        this.testGetSimpleFloat();
        this.testGetSimpleInt();
        this.testGetSimpleLong();
        this.testGetSimpleShort();
        this.testGetSimpleString();
        this.testMappedContains();
        this.testMappedRemove();
        try {
            this.bean = this.bean.getDynaClass().newInstance();
        }
        catch (Exception e) {
            BasicDynaBeanTestCase.fail((String)("Exception creating new instance: " + e));
        }
        this.testGetDescriptorArguments();
        this.testGetDescriptorBoolean();
        this.testGetDescriptorDouble();
        this.testGetDescriptorFloat();
        this.testGetDescriptorInt();
        this.testGetDescriptorLong();
        this.testGetDescriptorSecond();
        this.testGetDescriptorShort();
        this.testGetDescriptorString();
        this.testGetDescriptors();
    }

    public void testSetIndexedArguments() {
        try {
            this.bean.set("intArray", -1, (Object)new Integer(0));
            BasicDynaBeanTestCase.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
    }

    public void testSetIndexedValues() {
        Object value = null;
        try {
            this.bean.set("intArray", 0, (Object)new Integer(1));
            value = this.bean.get("intArray", 0);
            BasicDynaBeanTestCase.assertNotNull((String)"Returned new value 0", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Returned Integer new value 0", (boolean)(value instanceof Integer));
            BasicDynaBeanTestCase.assertEquals((String)"Returned correct new value 0", (int)1, (int)((Integer)value));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t));
        }
        try {
            this.bean.set("intIndexed", 1, (Object)new Integer(11));
            value = this.bean.get("intIndexed", 1);
            BasicDynaBeanTestCase.assertNotNull((String)"Returned new value 1", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Returned Integer new value 1", (boolean)(value instanceof Integer));
            BasicDynaBeanTestCase.assertEquals((String)"Returned correct new value 1", (int)11, (int)((Integer)value));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t));
        }
        try {
            this.bean.set("listIndexed", 2, (Object)"New Value 2");
            value = this.bean.get("listIndexed", 2);
            BasicDynaBeanTestCase.assertNotNull((String)"Returned new value 2", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Returned String new value 2", (boolean)(value instanceof String));
            BasicDynaBeanTestCase.assertEquals((String)"Returned correct new value 2", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t));
        }
        try {
            this.bean.set("stringArray", 3, (Object)"New Value 3");
            value = this.bean.get("stringArray", 3);
            BasicDynaBeanTestCase.assertNotNull((String)"Returned new value 3", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Returned String new value 3", (boolean)(value instanceof String));
            BasicDynaBeanTestCase.assertEquals((String)"Returned correct new value 3", (String)"New Value 3", (String)((String)value));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t));
        }
        try {
            this.bean.set("stringIndexed", 4, (Object)"New Value 4");
            value = this.bean.get("stringIndexed", 4);
            BasicDynaBeanTestCase.assertNotNull((String)"Returned new value 4", (Object)value);
            BasicDynaBeanTestCase.assertTrue((String)"Returned String new value 4", (boolean)(value instanceof String));
            BasicDynaBeanTestCase.assertEquals((String)"Returned correct new value 4", (String)"New Value 4", (String)((String)value));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw " + t));
        }
    }

    public void testSetMappedValues() {
        try {
            this.bean.set("mappedProperty", "First Key", (Object)"New First Value");
            BasicDynaBeanTestCase.assertEquals((String)"Can replace old value", (String)"New First Value", (String)((String)this.bean.get("mappedProperty", "First Key")));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Finding fourth value threw " + t));
        }
        try {
            this.bean.set("mappedProperty", "Fourth Key", (Object)"Fourth Value");
            BasicDynaBeanTestCase.assertEquals((String)"Can set new value", (String)"Fourth Value", (String)((String)this.bean.get("mappedProperty", "Fourth Key")));
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Finding fourth value threw " + t));
        }
    }

    public void testSetSimpleBoolean() {
        try {
            boolean oldValue = (Boolean)this.bean.get("booleanProperty");
            boolean newValue = !oldValue;
            this.bean.set("booleanProperty", (Object)new Boolean(newValue));
            BasicDynaBeanTestCase.assertTrue((String)"Matched new value", (newValue == (Boolean)this.bean.get("booleanProperty") ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleDouble() {
        try {
            double oldValue = (Double)this.bean.get("doubleProperty");
            double newValue = oldValue + 1.0;
            this.bean.set("doubleProperty", (Object)new Double(newValue));
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleFloat() {
        try {
            float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
            float newValue = oldValue + 1.0f;
            this.bean.set("floatProperty", (Object)new Float(newValue));
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleInt() {
        try {
            int oldValue = (Integer)this.bean.get("intProperty");
            int newValue = oldValue + 1;
            this.bean.set("intProperty", (Object)new Integer(newValue));
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (int)newValue, (int)((Integer)this.bean.get("intProperty")));
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleLong() {
        try {
            long oldValue = (Long)this.bean.get("longProperty");
            long newValue = oldValue + 1L;
            this.bean.set("longProperty", (Object)new Long(newValue));
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (long)newValue, (long)((Long)this.bean.get("longProperty")));
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleShort() {
        try {
            short oldValue = (Short)this.bean.get("shortProperty");
            short newValue = (short)(oldValue + 1);
            this.bean.set("shortProperty", (Object)new Short(newValue));
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (short)newValue, (short)((Short)this.bean.get("shortProperty")));
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    public void testSetSimpleString() {
        try {
            String oldValue = (String)this.bean.get("stringProperty");
            String newValue = oldValue + " Extra Value";
            this.bean.set("stringProperty", (Object)newValue);
            BasicDynaBeanTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)((String)this.bean.get("stringProperty")));
        }
        catch (Throwable e) {
            BasicDynaBeanTestCase.fail((String)("Exception: " + e));
        }
    }

    protected DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        BasicDynaClass dynaClass = new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
        return dynaClass;
    }

    protected void testGetDescriptorBase(String name, Class<?> type) {
        try {
            DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty(name);
            BasicDynaBeanTestCase.assertNotNull((String)"Got descriptor", (Object)descriptor);
            BasicDynaBeanTestCase.assertEquals((String)"Got correct type", type, (Object)descriptor.getType());
        }
        catch (Throwable t) {
            BasicDynaBeanTestCase.fail((String)("Threw an exception: " + t));
        }
    }
}

