/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;
import org.apache.commons.beanutils.converters.ShortConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public ShortConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Short("-12");
        this.numbers[1] = new Short("13");
        this.numbers[2] = new Short("-22");
        this.numbers[3] = new Short("23");
    }

    public static TestSuite suite() {
        return new TestSuite(ShortConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new ShortConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new ShortConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Short.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Short.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Short.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Short[] expected = new Short[]{new Short(Short.MIN_VALUE), new Short(-17), new Short(-1), new Short(0), new Short(1), new Short(17), new Short(Short.MAX_VALUE), new Short(7), new Short(8), new Short(9), new Short(10), new Short(11), new Short(12)};
        for (int i = 0; i < expected.length; ++i) {
            ShortConverterTestCase.assertEquals((String)(message[i] + " to Short"), (Object)expected[i], (Object)this.converter.convert(Short.class, input[i]));
            ShortConverterTestCase.assertEquals((String)(message[i] + " to short"), (Object)expected[i], (Object)this.converter.convert(Short.TYPE, input[i]));
            ShortConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Short> clazz = Short.class;
        Long min = new Long(-32768L);
        Long max = new Long(32767L);
        Long minMinusOne = new Long(min - 1L);
        Long maxPlusOne = new Long(max + 1L);
        ShortConverterTestCase.assertEquals((String)"Minimum", (Object)new Short(Short.MIN_VALUE), (Object)converter.convert(clazz, (Object)min));
        ShortConverterTestCase.assertEquals((String)"Maximum", (Object)new Short(Short.MAX_VALUE), (Object)converter.convert(clazz, (Object)max));
        try {
            ShortConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            ShortConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ShortConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            ShortConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

