/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.converters.ClassReloader;

public class ClassReloaderTestCase
extends TestCase {
    public ClassReloaderTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(ClassReloaderTestCase.class);
    }

    public void testBasicOperation() throws Exception {
        Class<DummyClass> sharedClass = DummyClass.class;
        ClassLoader sharedLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassReloader componentLoader = new ClassReloader(sharedLoader);
        Class<?> componentClass = componentLoader.reload(sharedClass);
        ClassReloaderTestCase.assertTrue((sharedClass != componentClass ? 1 : 0) != 0);
        ClassReloaderTestCase.assertSame((Object)sharedLoader, (Object)sharedClass.getClassLoader());
        ClassReloaderTestCase.assertSame((Object)componentLoader, (Object)componentClass.getClassLoader());
        ClassReloaderTestCase.assertTrue((sharedLoader != componentLoader ? 1 : 0) != 0);
        Object obj1 = sharedClass.newInstance();
        Object obj2 = componentClass.newInstance();
        ClassReloaderTestCase.assertTrue((String)"Obj1 class incorrect", (boolean)sharedClass.isInstance(obj1));
        ClassReloaderTestCase.assertFalse((String)"Obj1 class incorrect", (boolean)componentClass.isInstance(obj1));
        ClassReloaderTestCase.assertFalse((String)"Obj2 class incorrect", (boolean)sharedClass.isInstance(obj2));
        ClassReloaderTestCase.assertTrue((String)"Obj2 class incorrect", (boolean)componentClass.isInstance(obj2));
    }

    public static class DummyClass {
    }
}

