/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.CharacterConverter;

public class CharacterConverterTestCase
extends TestCase {
    public CharacterConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(CharacterConverterTestCase.class);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testConvertToString() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Character Test", (String)"N", (String)((String)converter.convert(String.class, (Object)new Character('N'))));
        CharacterConverterTestCase.assertEquals((String)"String Test", (String)"F", (String)((String)converter.convert(String.class, (Object)"FOO")));
        CharacterConverterTestCase.assertEquals((String)"Integer Test", (String)"3", (String)((String)converter.convert(String.class, (Object)new Integer(321))));
        CharacterConverterTestCase.assertEquals((String)"Null Test", null, (String)((String)converter.convert(String.class, null)));
    }

    public void testConvertToCharacter() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Character Test", (Object)new Character('N'), (Object)converter.convert(Character.class, (Object)new Character('N')));
        CharacterConverterTestCase.assertEquals((String)"String Test", (Object)new Character('F'), (Object)converter.convert(Character.class, (Object)"FOO"));
        CharacterConverterTestCase.assertEquals((String)"Integer Test", (Object)new Character('3'), (Object)converter.convert(Character.class, (Object)new Integer(321)));
    }

    public void testConvertToChar() {
        CharacterConverter converter = new CharacterConverter();
        CharacterConverterTestCase.assertEquals((String)"Wrong result", (Object)new Character('F'), (Object)converter.convert(Character.TYPE, (Object)"FOO"));
    }

    public void testConvertToCharacterNullNoDefault() {
        CharacterConverter converter = new CharacterConverter();
        try {
            converter.convert(Character.class, null);
            CharacterConverterTestCase.fail((String)"Expected a ConversionException for null value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefault() {
        CharacterConverter converter = new CharacterConverter((Object)"C");
        CharacterConverterTestCase.assertEquals((String)"Default Test", (Object)new Character('C'), (Object)converter.convert(Character.class, null));
    }

    public void testConvertToUnsupportedType() {
        CharacterConverter converter = new CharacterConverter();
        try {
            converter.convert(Integer.class, (Object)"Test");
            CharacterConverterTestCase.fail((String)"Could convert to unsupported type!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

