/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigInteger;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public BigIntegerConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new BigInteger("-12");
        this.numbers[1] = new BigInteger("13");
        this.numbers[2] = new BigInteger("-22");
        this.numbers[3] = new BigInteger("23");
    }

    public static TestSuite suite() {
        return new TestSuite(BigIntegerConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new BigIntegerConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new BigIntegerConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return BigInteger.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Long.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Long.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        BigInteger[] expected = new BigInteger[]{BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(-17L), BigInteger.valueOf(-1L), BigInteger.valueOf(0L), BigInteger.valueOf(1L), BigInteger.valueOf(17L), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(7L), BigInteger.valueOf(8L), BigInteger.valueOf(9L), BigInteger.valueOf(10L), BigInteger.valueOf(11L), BigInteger.valueOf(12L)};
        for (int i = 0; i < expected.length; ++i) {
            BigIntegerConverterTestCase.assertEquals((String)(message[i] + " to BigInteger"), (Object)expected[i], (Object)this.converter.convert(BigInteger.class, input[i]));
            BigIntegerConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

