/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.StringConverter;

public class ArrayConverterTestCase
extends TestCase {
    public ArrayConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(ArrayConverterTestCase.class);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testComponentIntegerConverter() {
        IntegerConverter intConverter = new IntegerConverter((Object)new Integer(0));
        intConverter.setPattern("#,###");
        intConverter.setLocale(Locale.US);
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)intConverter, 0);
        arrayConverter.setAllowedChars(new char[]{',', '-'});
        arrayConverter.setDelimiter(';');
        int[] intArray = new int[]{1111, 2222, 3333, 4444};
        String stringA = "1,111; 2,222; 3,333; 4,444";
        String stringB = intArray[0] + ";" + intArray[1] + ";" + intArray[2] + ";" + intArray[3];
        String[] strArray = new String[]{"" + intArray[0], "" + intArray[1], "" + intArray[2], "" + intArray[3]};
        long[] longArray = new long[]{intArray[0], intArray[1], intArray[2], intArray[3]};
        Long[] LONGArray = new Long[]{new Long(intArray[0]), new Long(intArray[1]), new Long(intArray[2]), new Long(intArray[3])};
        Integer[] IntegerArray = new Integer[]{new Integer(intArray[0]), new Integer(intArray[1]), new Integer(intArray[2]), new Integer(intArray[3])};
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<Long> longList = new ArrayList<Long>();
        for (int i = 0; i < strArray.length; ++i) {
            strList.add(strArray[i]);
            longList.add(LONGArray[i]);
        }
        String msg = null;
        try {
            msg = "String --> int[]";
            this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)stringA));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "String --> Integer[] (with braces)";
            this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, (Object)("{" + stringA + "}")));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "String[] --> int[]";
            this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)strArray));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "String[] --> Integer[]";
            this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, (Object)strArray));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "long[] --> int[]";
            this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)longArray));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "Long --> int[]";
            this.checkArray(msg, new int[]{LONGArray[0].intValue()}, arrayConverter.convert(int[].class, (Object)LONGArray[0]));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "LONG[] --> int[]";
            this.checkArray(msg, intArray, arrayConverter.convert(int[].class, (Object)LONGArray));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "Long --> String";
            ArrayConverterTestCase.assertEquals((String)msg, (String)(LONGArray[0] + ""), (String)((String)arrayConverter.convert(String.class, (Object)LONGArray[0])));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "LONG[] --> String (first)";
            ArrayConverterTestCase.assertEquals((String)msg, (String)(LONGArray[0] + ""), (String)((String)arrayConverter.convert(String.class, (Object)LONGArray)));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "LONG[] --> String (all)";
            arrayConverter.setOnlyFirstToString(false);
            ArrayConverterTestCase.assertEquals((String)msg, (String)stringB, (String)((String)arrayConverter.convert(String.class, (Object)LONGArray)));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "Collection of Long --> String";
            ArrayConverterTestCase.assertEquals((String)msg, (String)stringB, (String)((String)arrayConverter.convert(String.class, longList)));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "long[] --> String[]";
            this.checkArray(msg, strArray, arrayConverter.convert(String[].class, (Object)LONGArray));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "Collection of String --> Integer[]";
            this.checkArray(msg, IntegerArray, arrayConverter.convert(Integer[].class, strList));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "Collection of Long --> int[]";
            this.checkArray(msg, intArray, arrayConverter.convert(int[].class, longList));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
    }

    public void testStringArrayToNumber() {
        IntegerConverter intConverter = new IntegerConverter();
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)intConverter);
        String[] array = new String[]{"10", "  11", "12  ", "  13  "};
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        String msg = null;
        int[] expectedInt = new int[]{10, 11, 12, 13};
        Integer[] expectedInteger = new Integer[]{new Integer(expectedInt[0]), new Integer(expectedInt[1]), new Integer(expectedInt[2]), new Integer(expectedInt[3])};
        try {
            msg = "String[] --> int[]";
            this.checkArray(msg, expectedInt, arrayConverter.convert(int[].class, (Object)array));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "String[] --> Integer[]";
            this.checkArray(msg, expectedInteger, arrayConverter.convert(Integer[].class, (Object)array));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "List --> int[]";
            this.checkArray(msg, expectedInt, arrayConverter.convert(int[].class, list));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
        try {
            msg = "List --> Integer[]";
            this.checkArray(msg, expectedInteger, arrayConverter.convert(Integer[].class, list));
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)(msg + " failed " + e));
        }
    }

    public void testTheMatrix() {
        String matrixString = "11,12,13 ; 21,22,23 ; 31,32,33 ; 41,42,43";
        int[][] expected = new int[][]{{11, 12, 13}, {21, 22, 23}, {31, 32, 33}, {41, 42, 43}};
        IntegerConverter integerConverter = new IntegerConverter();
        ArrayConverter arrayConverter = new ArrayConverter(int[].class, (Converter)integerConverter);
        ArrayConverter matrixConverter = new ArrayConverter(int[][].class, (Converter)arrayConverter);
        matrixConverter.setDelimiter(';');
        matrixConverter.setAllowedChars(new char[]{','});
        try {
            Object result = matrixConverter.convert(int[][].class, (Object)matrixString);
            ArrayConverterTestCase.assertEquals((String)"Check int[][].class", int[][].class, result.getClass());
            int[][] matrix = (int[][])result;
            ArrayConverterTestCase.assertEquals((String)"Check int[][] length", (int)expected.length, (int)matrix.length);
            for (int i = 0; i < expected.length; ++i) {
                ArrayConverterTestCase.assertEquals((String)("Check int[" + i + "] length"), (int)expected[i].length, (int)matrix[i].length);
                for (int j = 0; j < expected[i].length; ++j) {
                    String label = "Matrix int[" + i + "," + j + "] element";
                    ArrayConverterTestCase.assertEquals((String)label, (int)expected[i][j], (int)matrix[i][j]);
                }
            }
        }
        catch (Exception e) {
            ArrayConverterTestCase.fail((String)("Matrix Conversion threw " + e));
        }
    }

    public void testInvalidWithDefault() {
        int[] zeroArray = new int[]{};
        int[] oneArray = new int[1];
        IntegerConverter intConverter = new IntegerConverter();
        ArrayConverterTestCase.assertEquals((String)"Null Default", null, (Object)new ArrayConverter(int[].class, (Converter)intConverter, -1).convert(int[].class, null));
        this.checkArray("Zero Length", zeroArray, new ArrayConverter(int[].class, (Converter)intConverter, 0).convert(int[].class, null));
        this.checkArray("One Length", oneArray, new ArrayConverter(Integer[].class, (Converter)intConverter, 1).convert(int[].class, null));
    }

    public void testEmptyString() {
        int[] zeroArray = new int[]{};
        IntegerConverter intConverter = new IntegerConverter();
        this.checkArray("Empty String", zeroArray, new ArrayConverter(int[].class, (Converter)intConverter, -1).convert(int[].class, (Object)""));
        ArrayConverterTestCase.assertEquals((String)"Default String", null, (String)((String)new ArrayConverter(int[].class, (Converter)intConverter).convert(String.class, null)));
    }

    public void testErrors() {
        try {
            new ArrayConverter(null, (Converter)new DateConverter());
            ArrayConverterTestCase.fail((String)"Default Type missing - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ArrayConverter(Boolean.class, (Converter)new DateConverter());
            ArrayConverterTestCase.fail((String)"Default Type not an array - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ArrayConverter(int[].class, null);
            ArrayConverterTestCase.fail((String)"Component Converter missing - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnderscore_BEANUTILS_302() {
        String value = "first_value,second_value";
        ArrayConverter converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        String[] result = (String[])converter.convert(String[].class, (Object)value);
        ArrayConverterTestCase.assertNotNull((String)"result.null", (Object)result);
        ArrayConverterTestCase.assertEquals((String)"result.length", (int)4, (int)result.length);
        ArrayConverterTestCase.assertEquals((String)"result[0]", (String)"first", (String)result[0]);
        ArrayConverterTestCase.assertEquals((String)"result[1]", (String)"value", (String)result[1]);
        ArrayConverterTestCase.assertEquals((String)"result[2]", (String)"second", (String)result[2]);
        ArrayConverterTestCase.assertEquals((String)"result[3]", (String)"value", (String)result[3]);
        converter.setAllowedChars(new char[]{'.', '-', '_'});
        result = (String[])converter.convert(String[].class, (Object)value);
        ArrayConverterTestCase.assertNotNull((String)"result.null", (Object)result);
        ArrayConverterTestCase.assertEquals((String)"result.length", (int)2, (int)result.length);
        ArrayConverterTestCase.assertEquals((String)"result[0]", (String)"first_value", (String)result[0]);
        ArrayConverterTestCase.assertEquals((String)"result[1]", (String)"second_value", (String)result[1]);
    }

    private void checkArray(String msg, Object expected, Object result) {
        ArrayConverterTestCase.assertNotNull((String)(msg + " Expected Null"), (Object)expected);
        ArrayConverterTestCase.assertNotNull((String)(msg + " Result   Null"), (Object)result);
        ArrayConverterTestCase.assertTrue((String)(msg + " Result   not array"), (boolean)result.getClass().isArray());
        ArrayConverterTestCase.assertTrue((String)(msg + " Expected not array"), (boolean)expected.getClass().isArray());
        int resultLth = Array.getLength(result);
        ArrayConverterTestCase.assertEquals((String)(msg + " Size"), (int)Array.getLength(expected), (int)resultLth);
        ArrayConverterTestCase.assertEquals((String)(msg + " Type"), expected.getClass(), result.getClass());
        for (int i = 0; i < resultLth; ++i) {
            Object expectElement = Array.get(expected, i);
            Object resultElement = Array.get(result, i);
            ArrayConverterTestCase.assertEquals((String)(msg + " Element " + i), (Object)expectElement, (Object)resultElement);
        }
    }
}

