/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.TestBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaBeanUtilsTestCase
extends TestCase {
    protected DynaBean bean = null;
    protected TestBean nested = null;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "byteProperty", "doubleProperty", "dupProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mapProperty", "mappedProperty", "mappedIntProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};

    public DynaBeanUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        ConvertUtils.deregister();
        DynaClass dynaClass = DynaBeanUtilsTestCase.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)new Boolean(true));
        this.bean.set("booleanSecond", (Object)new Boolean(true));
        this.bean.set("byteProperty", (Object)new Byte(121));
        this.bean.set("doubleProperty", (Object)new Double(321.0));
        this.bean.set("floatProperty", (Object)new Float(123.0f));
        String[] dupProperty = new String[]{"Dup 0", "Dup 1", "Dup 2", "Dup 3", "Dup 4"};
        this.bean.set("dupProperty", (Object)dupProperty);
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)new Integer(123));
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)new Long(321L));
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put("First Key", "First Value");
        mapProperty.put("Second Key", "Second Value");
        this.bean.set("mapProperty", mapProperty);
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", new Integer(1));
        mappedIntProperty.put("Two", new Integer(2));
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.nested = new TestBean();
        this.bean.set("nested", (Object)this.nested);
        this.bean.set("shortProperty", (Object)new Short(987));
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    public static Test suite() {
        return new TestSuite(DynaBeanUtilsTestCase.class);
    }

    public void tearDown() {
        this.bean = null;
        this.nested = null;
    }

    public void testCloneDynaBean() {
        DynaClass dynaClass = DynaBeanUtilsTestCase.createDynaClass();
        DynaBean orig = null;
        try {
            orig = dynaClass.newInstance();
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("newInstance(): " + e));
        }
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)new Byte(111));
        orig.set("doubleProperty", (Object)new Double(333.33));
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)new Integer(333));
        orig.set("longProperty", (Object)new Long(3333L));
        orig.set("shortProperty", (Object)new Short(33));
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        DynaBean clonedBean = null;
        try {
            clonedBean = (DynaBean)BeanUtils.cloneBean((Object)orig);
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("Threw exception: " + e));
        }
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned boolean property", (boolean)false, (boolean)((Boolean)clonedBean.get("booleanProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned byte property", (byte)111, (byte)((Byte)clonedBean.get("byteProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned double property", (double)333.33, (double)((Double)clonedBean.get("doubleProperty")), (double)0.005);
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned int property", (int)333, (int)((Integer)clonedBean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned long property", (long)3333L, (long)((Long)clonedBean.get("longProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned short property", (short)33, (short)((Short)clonedBean.get("shortProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Cloned string property", (String)"Custom string", (String)((String)clonedBean.get("stringProperty")));
        String[] dupProperty = (String[])clonedBean.get("dupProperty");
        DynaBeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = (int[])clonedBean.get("intArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)100, (int)intArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)200, (int)intArray[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)300, (int)intArray[2]);
        String[] stringArray = (String[])clonedBean.get("stringArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"stringArray present", (Object)stringArray);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New 0", (String)stringArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New 1", (String)stringArray[1]);
    }

    public void testCopyPropertiesDynaBean() {
        DynaClass dynaClass = DynaBeanUtilsTestCase.createDynaClass();
        DynaBean orig = null;
        try {
            orig = dynaClass.newInstance();
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("newInstance(): " + e));
        }
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)new Byte(111));
        orig.set("doubleProperty", (Object)new Double(333.33));
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)new Integer(333));
        orig.set("longProperty", (Object)new Long(3333L));
        orig.set("shortProperty", (Object)new Short(33));
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        try {
            BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("Threw exception: " + e));
        }
        DynaBeanUtilsTestCase.assertEquals((String)"Copied boolean property", (boolean)false, (boolean)((Boolean)this.bean.get("booleanProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied byte property", (byte)111, (byte)((Byte)this.bean.get("byteProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied double property", (double)333.33, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        DynaBeanUtilsTestCase.assertEquals((String)"Copied int property", (int)333, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied long property", (long)3333L, (long)((Long)this.bean.get("longProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied short property", (short)33, (short)((Short)this.bean.get("shortProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied string property", (String)"Custom string", (String)((String)this.bean.get("stringProperty")));
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        DynaBeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = (int[])this.bean.get("intArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)100, (int)intArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)200, (int)intArray[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)300, (int)intArray[2]);
        String[] stringArray = (String[])this.bean.get("stringArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"stringArray present", (Object)stringArray);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New 0", (String)stringArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New 1", (String)stringArray[1]);
    }

    public void testCopyPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", "false");
        map.put("byteProperty", "111");
        map.put("doubleProperty", "333.0");
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", "222.0");
        map.put("intArray", new String[]{"0", "100", "200"});
        map.put("intProperty", "111");
        map.put("longProperty", "444");
        map.put("shortProperty", "555");
        map.put("stringProperty", "New String Property");
        try {
            BeanUtils.copyProperties((Object)this.bean, map);
        }
        catch (Throwable t) {
            DynaBeanUtilsTestCase.fail((String)("Threw " + t.toString()));
        }
        DynaBeanUtilsTestCase.assertEquals((String)"booleanProperty", (boolean)false, (boolean)((Boolean)this.bean.get("booleanProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"byteProperty", (byte)111, (byte)((Byte)this.bean.get("byteProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"doubleProperty", (double)333.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        DynaBeanUtilsTestCase.assertEquals((String)"floatProperty", (float)222.0f, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
        DynaBeanUtilsTestCase.assertEquals((String)"intProperty", (int)111, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"longProperty", (long)444L, (long)((Long)this.bean.get("longProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"shortProperty", (short)555, (short)((Short)this.bean.get("shortProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"stringProperty", (String)"New String Property", (String)((String)this.bean.get("stringProperty")));
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        DynaBeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = (int[])this.bean.get("intArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)0, (int)intArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)100, (int)intArray[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)200, (int)intArray[2]);
    }

    public void testCopyPropertiesStandard() {
        TestBean orig = new TestBean();
        orig.setBooleanProperty(false);
        orig.setByteProperty((byte)111);
        orig.setDoubleProperty(333.33);
        orig.setDupProperty(new String[]{"New 0", "New 1", "New 2"});
        orig.setIntArray(new int[]{100, 200, 300});
        orig.setIntProperty(333);
        orig.setLongProperty(3333L);
        orig.setShortProperty((short)33);
        orig.setStringArray(new String[]{"New 0", "New 1"});
        orig.setStringProperty("Custom string");
        try {
            BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("Threw exception: " + e));
        }
        DynaBeanUtilsTestCase.assertEquals((String)"Copied boolean property", (boolean)false, (boolean)((Boolean)this.bean.get("booleanProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied byte property", (byte)111, (byte)((Byte)this.bean.get("byteProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied double property", (double)333.33, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        DynaBeanUtilsTestCase.assertEquals((String)"Copied int property", (int)333, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied long property", (long)3333L, (long)((Long)this.bean.get("longProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied short property", (short)33, (short)((Short)this.bean.get("shortProperty")));
        DynaBeanUtilsTestCase.assertEquals((String)"Copied string property", (String)"Custom string", (String)((String)this.bean.get("stringProperty")));
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        DynaBeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = (int[])this.bean.get("intArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)100, (int)intArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)200, (int)intArray[1]);
        DynaBeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)300, (int)intArray[2]);
        String[] stringArray = (String[])this.bean.get("stringArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"stringArray present", (Object)stringArray);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New 0", (String)stringArray[0]);
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New 1", (String)stringArray[1]);
    }

    public void testDescribe() {
        Map map = null;
        try {
            map = PropertyUtils.describe((Object)this.bean);
        }
        catch (Exception e) {
            DynaBeanUtilsTestCase.fail((String)("Threw exception " + e));
        }
        for (int i = 0; i < this.describes.length; ++i) {
            DynaBeanUtilsTestCase.assertTrue((String)("Property '" + this.describes[i] + "' is present"), (boolean)map.containsKey(this.describes[i]));
        }
        DynaBeanUtilsTestCase.assertTrue((String)"Property 'writeOnlyProperty' is not present", (!map.containsKey("writeOnlyProperty") ? 1 : 0) != 0);
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'booleanProperty'", (Object)Boolean.TRUE, map.get("booleanProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'byteProperty'", (Object)new Byte(121), map.get("byteProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'doubleProperty'", (Object)new Double(321.0), map.get("doubleProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'floatProperty'", (Object)new Float(123.0f), map.get("floatProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'intProperty'", (Object)new Integer(123), map.get("intProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'longProperty'", (Object)new Long(321L), map.get("longProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'shortProperty'", (Object)new Short(987), map.get("shortProperty"));
        DynaBeanUtilsTestCase.assertEquals((String)"Value of 'stringProperty'", (String)"This is a string", (String)((String)map.get("stringProperty")));
    }

    public void testPopulateArrayProperties() {
        try {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String[] intArrayIn = new String[]{"123", "456", "789"};
            map.put("intArray", intArrayIn);
            String[] stringArray = new String[]{"New String 0", "New String 1"};
            map.put("stringArray", stringArray);
            BeanUtils.populate((Object)this.bean, map);
            int[] intArray = (int[])this.bean.get("intArray");
            DynaBeanUtilsTestCase.assertNotNull((String)"intArray is present", (Object)intArray);
            DynaBeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
            DynaBeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)123, (int)intArray[0]);
            DynaBeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)456, (int)intArray[1]);
            DynaBeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)789, (int)intArray[2]);
            stringArray = (String[])this.bean.get("stringArray");
            DynaBeanUtilsTestCase.assertNotNull((String)"stringArray is present", (Object)stringArray);
            DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
            DynaBeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New String 0", (String)stringArray[0]);
            DynaBeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New String 1", (String)stringArray[1]);
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testGetArrayProperty() {
        try {
            String[] arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringArray");
            String[] comp = (String[])this.bean.get("stringArray");
            DynaBeanUtilsTestCase.assertTrue((String)("String array length = " + comp.length), (comp.length == arr.length ? 1 : 0) != 0);
            arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"intArray");
            int[] iarr = (int[])this.bean.get("intArray");
            DynaBeanUtilsTestCase.assertTrue((String)("String array length = " + iarr.length), (iarr.length == arr.length ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetIndexedProperty1() {
        try {
            String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
            String comp = String.valueOf(this.bean.get("intIndexed", 3));
            DynaBeanUtilsTestCase.assertTrue((String)("intIndexed[3] == " + comp), (boolean)val.equals(comp));
            val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed[3]");
            comp = (String)this.bean.get("stringIndexed", 3);
            DynaBeanUtilsTestCase.assertTrue((String)("stringIndexed[3] == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetIndexedProperty2() {
        try {
            String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)3);
            String comp = String.valueOf(this.bean.get("intIndexed", 3));
            DynaBeanUtilsTestCase.assertTrue((String)("intIndexed,3 == " + comp), (boolean)val.equals(comp));
            val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)3);
            comp = (String)this.bean.get("stringIndexed", 3);
            DynaBeanUtilsTestCase.assertTrue((String)("stringIndexed,3 == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedProperty() {
        try {
            String val = BeanUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
            String comp = this.nested.getStringProperty();
            DynaBeanUtilsTestCase.assertTrue((String)("nested.StringProperty == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetGeneralProperty() {
        try {
            String val = BeanUtils.getProperty((Object)this.bean, (String)"nested.intIndexed[2]");
            String comp = String.valueOf(this.bean.get("intIndexed", 2));
            DynaBeanUtilsTestCase.assertTrue((String)("nested.intIndexed[2] == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleProperty() {
        try {
            String val = BeanUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
            String comp = String.valueOf(this.bean.get("shortProperty"));
            DynaBeanUtilsTestCase.assertTrue((String)("shortProperty == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaBeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testPopulateArrayElements() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intIndexed[0]", "100");
            map.put("intIndexed[2]", "120");
            map.put("intIndexed[4]", "140");
            BeanUtils.populate((Object)this.bean, map);
            Integer intIndexed0 = (Integer)this.bean.get("intIndexed", 0);
            DynaBeanUtilsTestCase.assertEquals((String)"intIndexed[0] is 100", (int)100, (int)intIndexed0);
            Integer intIndexed1 = (Integer)this.bean.get("intIndexed", 1);
            DynaBeanUtilsTestCase.assertEquals((String)"intIndexed[1] is 10", (int)10, (int)intIndexed1);
            Integer intIndexed2 = (Integer)this.bean.get("intIndexed", 2);
            DynaBeanUtilsTestCase.assertEquals((String)"intIndexed[2] is 120", (int)120, (int)intIndexed2);
            Integer intIndexed3 = (Integer)this.bean.get("intIndexed", 3);
            DynaBeanUtilsTestCase.assertEquals((String)"intIndexed[3] is 30", (int)30, (int)intIndexed3);
            Integer intIndexed4 = (Integer)this.bean.get("intIndexed", 4);
            DynaBeanUtilsTestCase.assertEquals((String)"intIndexed[4] is 140", (int)140, (int)intIndexed4);
            map.clear();
            map.put("stringIndexed[1]", "New String 1");
            map.put("stringIndexed[3]", "New String 3");
            BeanUtils.populate((Object)this.bean, map);
            DynaBeanUtilsTestCase.assertEquals((String)"stringIndexed[0] is \"String 0\"", (String)"String 0", (String)((String)this.bean.get("stringIndexed", 0)));
            DynaBeanUtilsTestCase.assertEquals((String)"stringIndexed[1] is \"New String 1\"", (String)"New String 1", (String)((String)this.bean.get("stringIndexed", 1)));
            DynaBeanUtilsTestCase.assertEquals((String)"stringIndexed[2] is \"String 2\"", (String)"String 2", (String)((String)this.bean.get("stringIndexed", 2)));
            DynaBeanUtilsTestCase.assertEquals((String)"stringIndexed[3] is \"New String 3\"", (String)"New String 3", (String)((String)this.bean.get("stringIndexed", 3)));
            DynaBeanUtilsTestCase.assertEquals((String)"stringIndexed[4] is \"String 4\"", (String)"String 4", (String)((String)this.bean.get("stringIndexed", 4)));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateMapped() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("mappedProperty(First Key)", "New First Value");
            map.put("mappedProperty(Third Key)", "New Third Value");
            BeanUtils.populate((Object)this.bean, map);
            DynaBeanUtilsTestCase.assertEquals((String)"mappedProperty(First Key)", (String)"New First Value", (String)((String)this.bean.get("mappedProperty", "First Key")));
            DynaBeanUtilsTestCase.assertEquals((String)"mappedProperty(Second Key)", (String)"Second Value", (String)((String)this.bean.get("mappedProperty", "Second Key")));
            DynaBeanUtilsTestCase.assertEquals((String)"mappedProperty(Third Key)", (String)"New Third Value", (String)((String)this.bean.get("mappedProperty", "Third Key")));
            DynaBeanUtilsTestCase.assertNull((String)"mappedProperty(Fourth Key", (Object)this.bean.get("mappedProperty", "Fourth Key"));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateNested() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nested.booleanProperty", "false");
            map.put("nested.doubleProperty", "432.0");
            map.put("nested.intProperty", "543");
            map.put("nested.shortProperty", "654");
            BeanUtils.populate((Object)this.bean, map);
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaBeanUtilsTestCase.assertTrue((String)"booleanProperty is false", (!nested.getBooleanProperty() ? 1 : 0) != 0);
            DynaBeanUtilsTestCase.assertTrue((String)"booleanSecond is true", (boolean)nested.isBooleanSecond());
            DynaBeanUtilsTestCase.assertEquals((String)"doubleProperty is 432.0", (double)432.0, (double)nested.getDoubleProperty(), (double)0.005);
            DynaBeanUtilsTestCase.assertEquals((String)"floatProperty is 123.0", (float)123.0f, (float)nested.getFloatProperty(), (float)0.005f);
            DynaBeanUtilsTestCase.assertEquals((String)"intProperty is 543", (int)543, (int)nested.getIntProperty());
            DynaBeanUtilsTestCase.assertEquals((String)"longProperty is 321", (long)321L, (long)nested.getLongProperty());
            DynaBeanUtilsTestCase.assertEquals((String)"shortProperty is 654", (short)654, (short)nested.getShortProperty());
            DynaBeanUtilsTestCase.assertEquals((String)"stringProperty is \"This is a string\"", (String)"This is a string", (String)nested.getStringProperty());
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateScalar() {
        try {
            this.bean.set("nullProperty", (Object)"non-null value");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("booleanProperty", "false");
            map.put("doubleProperty", "432.0");
            map.put("intProperty", "543");
            map.put("nullProperty", null);
            map.put("shortProperty", "654");
            BeanUtils.populate((Object)this.bean, map);
            Boolean booleanProperty = (Boolean)this.bean.get("booleanProperty");
            DynaBeanUtilsTestCase.assertTrue((String)"booleanProperty is false", (booleanProperty == false ? 1 : 0) != 0);
            Boolean booleanSecond = (Boolean)this.bean.get("booleanSecond");
            DynaBeanUtilsTestCase.assertTrue((String)"booleanSecond is true", (boolean)booleanSecond);
            Double doubleProperty = (Double)this.bean.get("doubleProperty");
            DynaBeanUtilsTestCase.assertEquals((String)"doubleProperty is 432.0", (double)432.0, (double)doubleProperty, (double)0.005);
            Float floatProperty = (Float)this.bean.get("floatProperty");
            DynaBeanUtilsTestCase.assertEquals((String)"floatProperty is 123.0", (float)123.0f, (float)floatProperty.floatValue(), (float)0.005f);
            Integer intProperty = (Integer)this.bean.get("intProperty");
            DynaBeanUtilsTestCase.assertEquals((String)"intProperty is 543", (int)543, (int)intProperty);
            Long longProperty = (Long)this.bean.get("longProperty");
            DynaBeanUtilsTestCase.assertEquals((String)"longProperty is 321", (long)321L, (long)longProperty);
            DynaBeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.get("nullProperty"));
            Short shortProperty = (Short)this.bean.get("shortProperty");
            DynaBeanUtilsTestCase.assertEquals((String)"shortProperty is 654", (short)654, (short)shortProperty);
            DynaBeanUtilsTestCase.assertEquals((String)"stringProperty is \"This is a string\"", (String)"This is a string", (String)((String)this.bean.get("stringProperty")));
        }
        catch (IllegalAccessException e) {
            DynaBeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            DynaBeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testSetPropertyNullValues() throws Exception {
        Object oldValue = null;
        Object newValue = null;
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"stringArray is not null", (Object)newValue);
        DynaBeanUtilsTestCase.assertTrue((String)"stringArray of correct type", (boolean)(newValue instanceof String[]));
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)1, (int)((String[])newValue).length);
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray[2]", (Object)null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        DynaBeanUtilsTestCase.assertNotNull((String)"stringArray is not null", (Object)newValue);
        DynaBeanUtilsTestCase.assertTrue((String)"stringArray of correct type", (boolean)(newValue instanceof String[]));
        DynaBeanUtilsTestCase.assertEquals((String)"stringArray length", (int)5, (int)((String[])newValue).length);
        DynaBeanUtilsTestCase.assertTrue((String)"stringArray[2] is null", (((String[])newValue)[2] == null ? 1 : 0) != 0);
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", null);
        DynaBeanUtilsTestCase.assertTrue((String)"stringProperty is now null", (BeanUtils.getProperty((Object)this.bean, (String)"stringProperty") == null ? 1 : 0) != 0);
    }

    public void testSetPropertyOnPrimitiveWrappers() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"intProperty", (Object)new Integer(1));
        DynaBeanUtilsTestCase.assertEquals((int)1, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)new Integer(1));
        DynaBeanUtilsTestCase.assertEquals((int)1, (int)Integer.parseInt((String)this.bean.get("stringProperty")));
    }

    public void testSetPropertyNull() throws Exception {
        this.bean.set("nullProperty", (Object)"non-null value");
        BeanUtils.setProperty((Object)this.bean, (String)"nullProperty", null);
        DynaBeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.get("nullProperty"));
    }

    public void testCopyPropertyByte() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
    }

    public void testCopyPropertyDouble() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Double(123.0));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Float(123.0f));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
    }

    public void testCopyPropertyFloat() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Double(123.0));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Float(123.0f));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
    }

    public void testCopyPropertyInteger() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
    }

    public void testCopyPropertyLong() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
    }

    public void testCopyPropertyNull() throws Exception {
        this.bean.set("nullProperty", (Object)"non-null value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nullProperty", null);
        DynaBeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.get("nullProperty"));
    }

    public void testCopyPropertyShort() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Byte(123));
        DynaBeanUtilsTestCase.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Integer(123));
        DynaBeanUtilsTestCase.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Long(123L));
        DynaBeanUtilsTestCase.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Short(123));
        DynaBeanUtilsTestCase.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
    }

    public void testCopyPropertyNestedIndexedArray() throws Exception {
        int[] origArray = new int[]{0, 10, 20, 30, 40};
        int[] intArray = new int[]{0, 0, 0};
        ((TestBean)this.bean.get("nested")).setIntArray(intArray);
        int[] intChanged = new int[]{0, 0, 0};
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Integer(1));
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 1;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Byte(2));
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 2;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Long(3L));
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 3;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)"4");
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 4;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
    }

    public void testCopyPropertyNestedMappedMap() throws Exception {
        HashMap<String, String> origMap = new HashMap<String, String>();
        origMap.put("First Key", "First Value");
        origMap.put("Second Key", "Second Value");
        HashMap<String, String> changedMap = new HashMap<String, String>();
        changedMap.put("First Key", "First Value");
        changedMap.put("Second Key", "Second Value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.mapProperty(Second Key)", (Object)"New Second Value");
        this.checkMap((Map)this.bean.get("mapProperty"), origMap);
        changedMap.put("Second Key", "New Second Value");
        this.checkMap(((TestBean)this.bean.get("nested")).getMapProperty(), changedMap);
    }

    public void testCopyPropertyNestedSimple() throws Exception {
        this.bean.set("intProperty", (Object)new Integer(0));
        this.nested.setIntProperty(0);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Integer(1));
        DynaBeanUtilsTestCase.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((int)1, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Byte(2));
        DynaBeanUtilsTestCase.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((int)2, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Long(3L));
        DynaBeanUtilsTestCase.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((int)3, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)"4");
        DynaBeanUtilsTestCase.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        DynaBeanUtilsTestCase.assertEquals((int)4, (int)this.nested.getIntProperty());
    }

    protected void checkIntArray(int[] actual, int[] expected) {
        DynaBeanUtilsTestCase.assertNotNull((String)"actual array not null", (Object)actual);
        DynaBeanUtilsTestCase.assertEquals((String)"actual array length", (int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            DynaBeanUtilsTestCase.assertEquals((String)("actual array value[" + i + "]"), (int)expected[i], (int)actual[i]);
        }
    }

    protected void checkMap(Map<?, ?> actual, Map<?, ?> expected) {
        DynaBeanUtilsTestCase.assertNotNull((String)"actual map not null", actual);
        DynaBeanUtilsTestCase.assertEquals((String)"actual map size", (int)expected.size(), (int)actual.size());
        for (Object key : expected.keySet()) {
            DynaBeanUtilsTestCase.assertEquals((String)("actual map value(" + key + ")"), expected.get(key), actual.get(key));
        }
    }

    protected static DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        BasicDynaClass dynaClass = new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("byteProperty", Byte.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("dupProperty", stringArray.getClass()), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mapProperty", Map.class), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nested", TestBean.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
        return dynaClass;
    }
}

